/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.service.managedsystem.refcode.config;

import com.ibm.hwmca.fw.service.managedsystem.refcode.RefCode;
import com.ibm.hwmca.fw.service.managedsystem.refcode.UndefinedRefCodeException;
import com.ibm.hwmca.fw.service.managedsystem.refcode.config.RefCodeConfig;
import com.ibm.hwmca.fw.service.managedsystem.refcode.config.RefCodeConfigException;
import com.ibm.hwmca.fw.service.managedsystem.refcode.config.RefCodeResolver;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Map;

public class DefaultRefCodeResolver
implements RefCodeResolver {
    private static final String TRACE_MASKT = "XRVFxxxT";
    private static final String TRACE_MASKF = "XRVFxxxF";
    private static final String TRACE_MASKD = "XRVFxxxD";
    protected Map refCodesMap;
    protected String machineType;
    protected String machineModel;

    public DefaultRefCodeResolver(Map inputMap) throws RefCodeConfigException {
        this.machineType = (String)inputMap.get("TYPE");
        this.machineModel = (String)inputMap.get("MODEL");
        if (this.machineType == null) {
            throw new RefCodeConfigException("required key[TYPE] not specified");
        }
        if (this.machineModel == null) {
            throw new RefCodeConfigException("required key[MODEL] not specified");
        }
        try {
            this.refCodesMap = RefCodeConfig.getRefCodeMap(this.machineType, this.machineModel);
            Trace.trace(TRACE_MASKD, "DefaultRefCodeResolver, refCodesMap:" + this.refCodesMap);
        }
        catch (Exception thrown) {
            if (thrown instanceof RefCodeConfigException) {
                throw (RefCodeConfigException)thrown;
            }
            throw new RefCodeConfigException(thrown);
        }
    }

    public RefCode resolve(String refCodeString) throws UndefinedRefCodeException {
        if (!this.refCodesMap.containsKey(refCodeString)) {
            throw new UndefinedRefCodeException("for machine type[" + this.machineType + "],model[" + this.machineModel + "], refcode[" + refCodeString + "] is undefined");
        }
        return (RefCode)this.refCodesMap.get(refCodeString);
    }
}

